/**************************** Data In Parameter *******************************

 InFlag       -> The flag will be " SET " when MG84FL54BD receive data from PC
                 and stored in InBuffer[64] already.
 InLen        -> Size of data that stored in InBuffer[64]
 InBuffer[64] -> Data buffer

*******************************************************************************/
extern     BIT InFlag;
extern     BYTE InLen;
extern     XBYTE InBuffer[64];

extern     USBEVENT UsbEvent;

/****************************** Function Call *********************************


 Initial();                             -> Will enable USB function that include
                                           " Device Firmware Upgrade "
 USB_Send_Data_To_PC( Size , *Buffer ); -> Size   --> The maximum number of bytes 
                                                      will be send to PC.
                                           *Buffer --> A pointer to the buffer that 
                                                       content the data will be send 
                                                       to PC.
 USB_Read_Data_Complete();              -> Will release buffer for next data  
                                           transfer from PC

*******************************************************************************/
extern     void Initial( void );
extern     void USB_Send_Data_To_PC( BYTE , BYTE * );
extern     void USB_Read_Data_Complete( void );